function [peak_pos, kpeak, vel, g0peak] = ...
    get_peak_pos_gray(energy_gray_min, energy_gray_max, ...
    tri, data_slant, scat)


% Extra distance such that the wavefunction is set to zero at a distance of
% amech from first site
dis_extra = (1 - rem(tri.Leff_corr,1)/2)*tri.amech_corr;

% k-values obtained by setting wavefunction to zero at a distance of
% amech from first site
num_points = ceil(tri.Leff_corr);
n = linspace(2*num_points, 0, 2*num_points+1);
k = ((-1).^n*asin(-1i*scat.r2) + n*pi)/(2*(tri.L*tri.amech + dis_extra));

% Get peak positions, kpeak, g0peak
peak_ene = interp1(data_slant.k, data_slant.energy, ...
    k);

kpeak = k(peak_ene>energy_gray_min & peak_ene<energy_gray_max);
peak_pos = interp1(data_slant.k, data_slant.energy, ...
    kpeak);
g0peak = interp1(data_slant.k, data_slant.g0, ...
    kpeak);

% Get group velocity
delta_k = (data_slant.k(2) - data_slant.k(1))/1000;
disp_peak_pos = interp1(data_slant.k, data_slant.energy, ...
    kpeak+delta_k);
vel = abs((disp_peak_pos - peak_pos)/delta_k);

end